

<?php $__env->startSection('title'); ?>
    Premium Package
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
<div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0 text-dark">Premium Package</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
            <li class="breadcrumb-item active">All Packages</li>
          </ol>
        </div>
      </div>
    </div>
  </div>
  
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <form action="<?php echo e(route('admin.premium-package.store')); ?>" method="POST" novalidate="novalidate" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">New Package</h3>
                    </div>
                    <div class="card-body row">
                        <div class="form-group col-md-8">
                            <label for="name">Name</label>
                            <input type="text" class="form-control" id="name" name="name" placeholder="Enter name">
                        </div>
 
                        <div class="form-group col-md-2">
                            <label for="duration">Duration (Days)</label>
                            <input type="number" class="form-control" id="duration" name="duration" value="0">
                        </div>
 
                        <div class="form-group col-md-2">
                            <label for="cost">Cost</label>
                            <input type="number" class="form-control" step="0.001" id="cost" name="cost" value="0">
                        </div>

                        <input type="hidden" class="form-control" id="feature_serial" value="0">
                        <div class="form-group col-12">
                            <label for="features">Feature</label>
                            <div id="new_package_feature_area">
                                <div class="input-group mb-2" id="new_feature_0">
                                    <input type="text" class="form-control" name="features[]">
                                </div>
                            </div>
                            <div class="mt-1"><button type="button" class="btn btn-sm btn-info" onclick="addNewFeature()">New</button></div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-success"> <i class="fas fa-save"></i> Submit</button>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-12">
          <!-- small box -->
          <div class="card card-success">
            <div class="card-header">
              <h3 class="card-title">All Packages</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>Name</th>
                  <th width="6%">Duration</th>
                  <th width="6%">Cost</th>
                  <th>Features</th>
                  <th width="6%">Action</th>
                </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($data->name); ?></td>
                            <td><?php echo e($data->duration); ?> days</td>
                            <td><?php echo e($data->cost); ?> $</td>
                            <?php
                                $features = explode("|",$data->features);
                            ?>
                            <td>
                                <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f_key=>$feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <p class="mb-1"><?php echo e($f_key + 1); ?>. <?php echo e($feature); ?></p>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td>
                                <button type="button" class="btn btn-sm btn-info" onclick="editPackage('<?php echo e($data->id); ?>')"><i class="fas fa-edit"></i></button>
                                <a href="<?php echo e(route('admin.premium-package.delete',$data->id)); ?>" onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm"><i class="fas fa-trash-alt"></i></a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
        </div>
      </div>
      
        <div class="modal fade" id="package_update_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Package Update</h5>
                        <button type="button" class="btn btn-sm btn-danger" onclick="closePackageUpdateModal()">Close</button>
                    </div>
                    <div class="modal-body" id="package_update_modal_body">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
  </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>

    <script>
        $(function () {
          $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
          });
          $('#example2').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
          });
        });
        
        function addNewFeature(){
            var feature_serial = parseInt($('#feature_serial').val());
            feature_serial += 1;
            var new_feature = '<div class="input-group mb-2" id="new_feature_'+feature_serial+'"><input type="text" class="form-control" name="features[]"><button type="button" class="btn btn-sm btn-danger" onclick="deleteNewFeature('+feature_serial+')">Delete</button></div>';
            $('#new_package_feature_area').append(new_feature);
            $('#feature_serial').val(feature_serial);
        }
        
        function deleteNewFeature(feature_serial){
            console.log(feature_serial);
            $('#new_feature_'+feature_serial).remove();
        }
        
        function editPackage(id){
            $.ajax({
                url: "<?php echo e(route('admin.get-premium-package-for-update')); ?>",
                type:"POST",
                data:{
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: id,
                },
                success:function(data) {
                    console.log(data);
                    $('#package_update_modal_body').html(data);
                },
            });
            
            $('#package_update_modal').modal('show');
        }
        
        function closePackageUpdateModal(){
            $('#package_update_modal').modal('hide');
        }
        
        function addUpdateFeature(id){
            var feature_serial = parseInt($('#update_feature_serial_'+id).val());
            feature_serial += 1;
            var new_feature = '<div class="input-group mb-2" id="update_feature_'+id+'_'+feature_serial+'"><input type="text" class="form-control" name="features[]"><button type="button" class="btn btn-sm btn-danger" onclick="deleteUpdateFeature('+id+', '+feature_serial+')">Delete</button></div>';
            $('#update_package_feature_area_'+id).append(new_feature);
            $('#update_feature_serial_'+id).val(feature_serial);
        }
        
        function deleteUpdateFeature(id, feature_serial){
            $('#update_feature_'+id+'_'+feature_serial).remove();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/powerwor/public_html/resources/views/backend/pages/premium-package/index.blade.php ENDPATH**/ ?>